/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.PIParseResponse;
import java.util.Date;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;

public class FspQueryData {
    private UnsignedInt16 mIntfVerFamily;
    private UnsignedInt16 mFspType;
    private UnsignedInt16 mMajorVersion;
    private UnsignedInt16 mMinorVersion;
    private UnsignedInt16 mCmdServerConnState;
    private UnsignedInt32 mStreamServerVportNum;
    private UnsignedInt16 mStreamServerConnState;
    private UnsignedInt16 mPendPwChgBitfld;
    private UnsignedInt16 mBrand;
    private UnsignedInt64 mCSLstFailTime;
    private UnsignedInt16 mCSExtFailReason;
    private UnsignedInt16 mCSIntFailReasonCat;
    private UnsignedInt32 mCSIntFailReasonCode;
    private UnsignedInt64 mSSLstFailTime;
    private UnsignedInt16 mSSExtFailReason;
    private UnsignedInt16 mSSIntFailReasonCat;
    private UnsignedInt32 mSSIntFailReasonCode;
    private String mIpAddr;
    private String mMtms;
    private long mChangeTime = 0L;
    private UnsignedInt16 mFspRole;
    private UnsignedInt16 mCounter;
    private static final String FSP_TYPE = "FSP_TYPE";
    private static final String INTF_VER_FAMILY = "INTF_VER_FAMILY";
    private static final String MAJOR_VER = "MAJOR_VER";
    private static final String MINOR_VER = "MINOR_VER";
    private static final String CONN_STATE = "CONN_STATE";
    private static final String SS_VPORT_NUM = "SS_VPORT_NUM";
    private static final String SS_CONN_STATE = "SS_CONN_STATE";
    private static final String PEND_PW_CHG_BITFLD = "PEND_PW_CHG_BITFLD";
    private static final String BRAND = "BRAND";
    private static final String IP_ADDR = "IP_ADDR";
    private static final String MTMS = "MTMS";
    private static final String LST_FAIL_TIME = "LST_FAIL_TIME";
    private static final String EXT_REASON = "EXT_REASON";
    private static final String INT_REASON_CAT = "INT_REASON_CAT";
    private static final String INT_REASON_CODE = "INT_REASON_CODE";
    private static final String SS_LST_FAIL_TIME = "SS_LST_FAIL_TIME";
    private static final String SS_EXT_REASON = "SS_EXT_REASON";
    private static final String SS_INT_REASON_CAT = "SS_INT_REASON_CAT";
    private static final String SS_INT_REASON_CODE = "SS_INT_REASON_CODE";
    private static final String FSP_ROLE = "FSP_ROLE";
    private static final String FSP_QUERY_DATA = "FSP_QUERY_DATA";
    private static final String FSP_PRIMARY_COUNTER = "FSP_PRIMARY_COUNTER";

    public FspQueryData(HardwareServerMessage hardwareServerMessage) {
        this.loadData(hardwareServerMessage.getPayload(), hardwareServerMessage.getVirtualPort());
    }

    public FspQueryData() {
    }

    public void setChangeTime(long l) {
        this.mChangeTime = l;
    }

    public long getChangeTime() {
        return this.mChangeTime;
    }

    private void loadData(byte[] byArray, int n) {
        try {
            Hashtable hashtable = PIParseResponse.parseByCmd(FSP_QUERY_DATA, byArray);
            System.out.println("resp: " + hashtable);
            this.mIntfVerFamily = (UnsignedInt16)hashtable.get(INTF_VER_FAMILY);
            this.mFspType = (UnsignedInt16)hashtable.get(FSP_TYPE);
            this.mMajorVersion = (UnsignedInt16)hashtable.get(MAJOR_VER);
            this.mMinorVersion = (UnsignedInt16)hashtable.get(MINOR_VER);
            this.mCmdServerConnState = (UnsignedInt16)hashtable.get(CONN_STATE);
            this.mStreamServerVportNum = (UnsignedInt32)hashtable.get(SS_VPORT_NUM);
            this.mStreamServerConnState = (UnsignedInt16)hashtable.get(SS_CONN_STATE);
            this.mPendPwChgBitfld = (UnsignedInt16)hashtable.get(PEND_PW_CHG_BITFLD);
            this.mBrand = (UnsignedInt16)hashtable.get(BRAND);
            this.mIpAddr = (String)hashtable.get(IP_ADDR);
            this.mMtms = (String)hashtable.get(MTMS);
            this.mCSLstFailTime = (UnsignedInt64)hashtable.get(LST_FAIL_TIME);
            if (this.mCSLstFailTime == null) {
                this.mCSLstFailTime = new UnsignedInt64("0");
            }
            this.mCSExtFailReason = (UnsignedInt16)hashtable.get(EXT_REASON);
            if (this.mCSExtFailReason == null) {
                this.mCSExtFailReason = new UnsignedInt16(0);
            }
            System.out.println("mCSExtFailReason: " + this.mCSExtFailReason);
            this.mCSIntFailReasonCat = (UnsignedInt16)hashtable.get(INT_REASON_CAT);
            if (this.mCSIntFailReasonCat == null) {
                this.mCSIntFailReasonCat = new UnsignedInt16(0);
            }
            this.mCSIntFailReasonCode = (UnsignedInt32)hashtable.get(INT_REASON_CODE);
            if (this.mCSIntFailReasonCode == null) {
                this.mCSIntFailReasonCode = new UnsignedInt32(0L);
            }
            this.mSSLstFailTime = (UnsignedInt64)hashtable.get(SS_LST_FAIL_TIME);
            if (this.mSSLstFailTime == null) {
                this.mSSLstFailTime = new UnsignedInt64("0");
            }
            this.mSSExtFailReason = (UnsignedInt16)hashtable.get(SS_EXT_REASON);
            System.out.println("mSSExtFailReason: " + this.mSSExtFailReason);
            if (this.mSSExtFailReason == null) {
                this.mSSExtFailReason = new UnsignedInt16(0);
            }
            this.mSSIntFailReasonCat = (UnsignedInt16)hashtable.get(SS_INT_REASON_CAT);
            if (this.mSSIntFailReasonCat == null) {
                this.mSSIntFailReasonCat = new UnsignedInt16(0);
            }
            this.mSSIntFailReasonCode = (UnsignedInt32)hashtable.get(SS_INT_REASON_CODE);
            if (this.mSSIntFailReasonCode == null) {
                this.mSSIntFailReasonCode = new UnsignedInt32(0L);
            }
            this.mFspRole = (UnsignedInt16)hashtable.get(FSP_ROLE);
            this.mCounter = hashtable.get(FSP_PRIMARY_COUNTER) == null ? new UnsignedInt16(0) : new UnsignedInt16(hashtable.get(FSP_PRIMARY_COUNTER).toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public UnsignedInt16 getInterfaceVersionFamily() {
        return this.mIntfVerFamily;
    }

    public UnsignedInt16 getFspType() {
        return this.mFspType;
    }

    public boolean isFrame() {
        return this.mFspType.intValue() == 1;
    }

    public UnsignedInt16 getMajorVersion() {
        return this.mMajorVersion;
    }

    public UnsignedInt16 getMinorVersion() {
        return this.mMinorVersion;
    }

    public String getVersionStr() {
        return ByteUtilities.toHexString(this.mMajorVersion) + ByteUtilities.toHexString(this.mMinorVersion);
    }

    public UnsignedInt16 getCmdServerConnState() {
        if (this.mCSExtFailReason.longValue() == 1029L || this.mCSExtFailReason.longValue() == 8L) {
            return new UnsignedInt16(32770);
        }
        return this.mCmdServerConnState;
    }

    public void setCmdServerConnState(UnsignedInt16 unsignedInt16) {
        this.mCmdServerConnState = unsignedInt16;
    }

    public UnsignedInt32 getStreamServerVportNumber() {
        return this.mStreamServerVportNum;
    }

    public UnsignedInt16 getStreamServerConnState() {
        return this.mStreamServerConnState;
    }

    public UnsignedInt16 getPendingPasswordChangeBitfield() {
        return this.mPendPwChgBitfld;
    }

    public UnsignedInt16 getBrand() {
        return this.mBrand;
    }

    public String getIpAddress() {
        return this.mIpAddr;
    }

    public String getMtms() {
        return this.mMtms;
    }

    public UnsignedInt64 getLastCmdServerFailedTime() {
        return this.mCSLstFailTime;
    }

    public UnsignedInt16 getCmdServerFailedExtReason() {
        return this.mCSExtFailReason;
    }

    public UnsignedInt16 getCmdServerFailedIntReasonCategory() {
        return this.mCSIntFailReasonCat;
    }

    public UnsignedInt32 getCmdServerFailedIntReasonCode() {
        return this.mCSIntFailReasonCode;
    }

    public String getHexString(long l, int n) {
        String string = Long.toHexString(l).toUpperCase();
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public String getLasttCmdServerFailedTimeStr() {
        return new Date(this.mCSLstFailTime.longValue()).toString();
    }

    public UnsignedInt64 getLastStreamServerFailedTime() {
        return this.mSSLstFailTime;
    }

    public UnsignedInt16 getStreamServerFailedExtReason() {
        return this.mSSExtFailReason;
    }

    public UnsignedInt16 getStreamServerFailedIntReasonCategory() {
        return this.mSSIntFailReasonCat;
    }

    public UnsignedInt32 getStreamServerFailedIntReasonCode() {
        return this.mSSIntFailReasonCode;
    }

    public String getCmdServerFailedExtReasonStr() {
        String string = "" + this.getHexString(this.mCSExtFailReason.longValue(), 4) + "-" + this.getHexString(this.mCSIntFailReasonCat.longValue(), 4) + "-" + this.getHexString(this.mCSIntFailReasonCode.longValue(), 8);
        System.out.println(" getCmdServerFailedExtReasonStr: " + string);
        return string;
    }

    public UnsignedInt16 getFspRole() {
        return this.mFspRole;
    }

    public String getLocationCode() {
        if (!this.isFrame()) {
            if (this.mFspRole.intValue() == 1) {
                return "PRIMARY";
            }
            if (this.mFspRole.intValue() == 2) {
                return "SECONDARY";
            }
            return "UNKNOWN_" + this.mIpAddr;
        }
        if (this.mFspRole.intValue() == 1) {
            return "SIDE_A";
        }
        if (this.mFspRole.intValue() == 2) {
            return "SIDE_B";
        }
        return "SIDE_UNKNOWN_" + this.mIpAddr;
    }

    public int getPrimaryCount() {
        return this.mCounter.intValue();
    }
}

